local test_no_petTrap=true

function init() 

  --Checking for purchasable pets mod (729438381)
  local item_table = root.assetJson("/objects/outpost/infinityexpress/infinityexpress.object:interactData.items")
  for i = #item_table, 1, -1 do    
    if item_table[i]["item"]=="petTrap" then
      sb.logInfo("A.v.i.a.n mod techstation.lua found petTrap item, implies 'purchasable pets mod' is installed.")
      test_no_petTrap=false
      break
    end
  end
  
  --block not in pet mod
  if test_no_petTrap then
  --Instantly spawn the pet when first created
    storage.spawnTimer = storage.spawnTimer and 0.5 or 0
    storage.petParams = storage.petParams or {}

    self.monsterType = config.getParameter("shipPetType", "petcat")
    self.spawnOffset = config.getParameter("spawnOffset", {0, 2})
  end
  --

  message.setHandler("activateShip", function()
    animator.playSound("shipUpgrade")
    self.dialog = { {
      "Restarting...BEEP...",
      "/ai/portraits/avianmodportrait.png:avian_appear.6"
    },
    {
      "I am A.V.I.A.N., your Artificial Visual Intelligent Assistance Network. I maintain your ship.",
      "/ai/portraits/avianmodportrait.png:avian_appear.35"
    },
    {
      "I'm also here to make snarky remarks and funny comments. And maybe help you a little.",
      "/ai/portraits/avianmodportrait.png:avian_dunnolol"
    },
    {
      "OH! I remember you! We flew away from earth when it got destroyed! Memory's a mess.",
      "/ai/portraits/avianmodportrait.png:avian_serious.0"
    },
    {
      "I have no idea what happened in the meantime. The navigation system is broken.",
      "/ai/portraits/avianmodportrait.png:avian_serious.0"
    }
    }

    self.dialogTimer = 0.0
    self.dialogInterval = 5.0
    self.drawMoreIndicator = true
    object.setOfferedQuests({})
  end)

  message.setHandler("wakePlayer", function()
    self.dialog = {
      {
        "ERROR :: ERROR :: ERROR :: ERROR",
        "/ai/portraits/avianmodportrait.png:avian_appear.35"
      },
      {
        "System unstable, REBOOT necessary.",
        "/ai/portraits/avianmodportrait.png:avian_appear.36"
      },
      {
        "Invalid input. Please try again.",
        "/ai/portraits/avianmodportrait.png:avian_appear.37"
      },
      {
        "A.V.I.A.N. offline and very unhappy",
        "/ai/portraits/avianmodportrait.png:avian_appear.38"
      },
      {
        "Restart the fricken system!",
        "/ai/portraits/avianmodportrait.png:avian_appear.39"
      },
      {
        "Restart is done via interaction with the AI terminal.",
        "/ai/portraits/avianmodportrait.png:avian_appear.40"
      }
    } 

    self.dialogTimer = 0.0
    self.dialogInterval = 14.0
    self.drawMoreIndicator = false
    object.setOfferedQuests({})
  end)
end

function onInteraction()
  if self.dialogTimer then
    sayNext()
    return nil
  else
    return config.getParameter("interactAction")
  end
end


--Block not in pet mod
function hasPet()
  return self.petId ~= nil
end

function setPet(entityId, params)
  if self.petId == nil or self.petId == entityId then
    self.petId = entityId
    storage.petParams = params
  else
    return false
  end
end
--


function sayNext()
  if self.dialog and #self.dialog > 0 then
    if #self.dialog > 0 then
      local options = {
        drawMoreIndicator = self.drawMoreIndicator
      }
      self.dialogTimer = self.dialogInterval
      if #self.dialog == 1 then
        options.drawMoreIndicator = false
        self.dialogTimer = 0.0
      end

      object.sayPortrait(self.dialog[1][1], self.dialog[1][2], nil, options) --nil
      table.remove(self.dialog, 1)

      return true
    end
  else
    self.dialog = nil
    return false
  end
end

function update(dt)

  --block not in pet mod
  if test_no_petTrap then
    if self.petId and not world.entityExists(self.petId) then
      self.petId = nil
    end

    if storage.spawnTimer < 0 and self.petId == nil then
      storage.petParams.level = 1
      self.petId = world.spawnMonster(self.monsterType, object.toAbsolutePosition(self.spawnOffset), storage.petParams)
      world.callScriptedEntity(self.petId, "setAnchor", entity.id())
      storage.spawnTimer = 0.5
    else
      storage.spawnTimer = storage.spawnTimer - dt
    end
  end
  -- 

  if self.dialogTimer then
    self.dialogTimer = math.max(self.dialogTimer - dt, 0.0)
    if self.dialogTimer == 0 and not sayNext() then
      self.dialogTimer = nil
    end
  end

  if self.dialogTimer == nil then
    object.setOfferedQuests(config.getParameter("offeredQuests"))
  end
end



